function Game() {
	this.canvas = null;
	this.stage = null;

	this.preloader = null; // preloader class
	this.container = null; // pointer to currently active container (map or interior)
	this.manifest = []; // list of asset names to load

	this.map = null; // object representing main city map, includes cars and buildings
	this.interiors = []; // an array of Interior objects (banks, offices, institutions etc)
	this.currentInterior = -1; // id of currently active interior

	this.mousePos = {
		x: 300,
		y: 300
	}; // this is for smooth scrolling, set to 300
	this.mouseOldPos = {
		x: 300,
		y: 300
	}; // instead of 0 to avoid scrolling on startup

	this.scrollable = false;
	this.tooltipElement = [];

	this._enableMapMovement = true;
}

Game.prototype.getCurrentInterior = function() {
	if (this.currentInterior !== -1)
		return this.interiors[this.currentInterior];
	else
		return null;
}

Game.prototype.getInterior = function(name) {
	return this.interiors[name];
}

Game.prototype.refreshScene = function() {
	stage.update();

	// HACK: wnętrze komputera po pobraniu widoku nie odswieza się dopoki nie
	// ruszy się myszką. Wysłanie zdarzenia powoduje przerysowanie sceny
	// Trzeba to zrobić jakos lepiej
	e = $.Event('mousemove');
	e.pageX = this.mousePos.x;
	e.pageY = this.mousePos.y;
	$(document).trigger(e);
}

Game.prototype.debugEnableAllBuildings = function(enable) {
	var e = typeof enable !== 'undefined' ? !enable : false;
	for (var i in this.map.buildings)
		this.map.buildings[i].setDisabled(e); // false
}

Game.prototype.enableAllowedBuildings = function() {
	if (window.userdata && window.userdata.allowedInteriors) {
		for (var bId in this.map.buildings) {
			var building = this.map.buildings[bId];
			if (window.userdata.allowedInteriors[bId] !== undefined)
				building.setDisabled(false);
			else if (building.interiorGroup)
				building.setDisabled(window.userdata.allowedInteriors[building.interiorGroup] === undefined);
			else {
				var budDat = building.getBuildingData();
				if (budDat && budDat.rodzajBudynku)
					building.setDisabled(window.userdata.allowedInteriors[budDat.rodzajBudynku] === undefined);
				else
					building.setDisabled(true);
			}
		}
	}
}

Game.prototype.init = function(canvasElementId) {
	if (this.stage === null) {
		// basic settings
		$("#loader").fadeIn(1000);

		this.stage = new createjs.Stage(canvasElementId);
		this.stage.enableMouseOver(5); //10);
		this.stage.mouseMoveOutside = true;
		this.canvas = this.stage.canvas;
		createjs.Touch.enable(this.stage);

		// preloader
		this.manifest = [
			// brakujace obrazki
			{
				src: window.links.baseUrl + "/images/chrome_logo.png"
			}, {
				src: window.links.baseUrl + "/images/favicon.ico"
			}, {
				src: window.links.baseUrl + "/images/green-check-green.png"
			}, {
				src: window.links.baseUrl + "/images/ajax-loader.gif"
			}, {
				src: window.links.baseUrl + "/images/loader.gif"
			},

			// avatary pracownikow
			{
				src: window.links.baseUrl + "/images/avatars/biologia/4.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/1.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/2.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/3.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/4.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/5.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/6.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/7.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/8.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/chemia/9.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/2.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/3.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/5.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/6.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/7.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/8.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/9.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/12.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/16.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/dodatkowe/21.jpg"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/5.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/6.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/7.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/8.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/fizyka/9.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/1.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/2.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/3.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/4.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/5.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/6.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/7.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/8.png"
			}, {
				src: window.links.baseUrl + "/images/avatars/matematyka/9.png"
			},

			// stopka
			{
				src: window.links.baseUrl + "/images/footer/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo-pokl.png"
			}, {
				src: window.links.baseUrl + "/images/footer/logo-ue.png"
			},

			// formularze

			{
				src: window.links.baseUrl + "/images/form-backgrounds/certificate/1.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form1/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form1/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form1/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form2/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form2/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form2/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form2/004.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/004.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/005.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form3/006.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form4/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form4/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form4/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form4/004.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form5/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form5/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form6/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form7/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form7/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form8/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form8/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form8/003.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form9/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form9/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form10/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form10/002.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form11/001.jpg"
			}, {
				src: window.links.baseUrl + "/images/form-backgrounds/form11/002.jpg"
			},

			// maps
			{
				src: window.links.baseUrl + "/images/maps/city1.jpg",
				id: "cityImg"
			},

			// cars
			{
				src: window.links.baseUrl + "/images/cars/trolejbus.png",
				id: "trolejbus"
			}, {
				src: window.links.baseUrl + "/images/cars/chevrolet.png",
				id: "chevrolet"
			}, {
				src: window.links.baseUrl + "/images/cars/chevrolet2.png",
				id: "chevrolet2"
			}, {
				src: window.links.baseUrl + "/images/cars/chevrolet3.png",
				id: "chevrolet3"
			}, {
				src: window.links.baseUrl + "/images/cars/chevrolet4.png",
				id: "chevrolet4"
			}, {
				src: window.links.baseUrl + "/images/cars/porsche.png",
				id: "porsche"
			}, {
				src: window.links.baseUrl + "/images/cars/porsche2.png",
				id: "porsche2"
			}, {
				src: window.links.baseUrl + "/images/cars/porsche3.png",
				id: "porsche3"
			}, {
				src: window.links.baseUrl + "/images/cars/porsche4.png",
				id: "porsche4"
			}, {
				src: window.links.baseUrl + "/images/cars/smart.png",
				id: "smart"
			}, {
				src: window.links.baseUrl + "/images/cars/smart2.png",
				id: "smart2"
			}, {
				src: window.links.baseUrl + "/images/cars/smart3.png",
				id: "smart3"
			}, {
				src: window.links.baseUrl + "/images/cars/smart4.png",
				id: "smart4"
			}, {
				src: window.links.baseUrl + "/images/cars/star.png",
				id: "star"
			}, {
				src: window.links.baseUrl + "/images/cars/star2.png",
				id: "star2"
			}, {
				src: window.links.baseUrl + "/images/cars/star3.png",
				id: "star3"
			}, {
				src: window.links.baseUrl + "/images/cars/star4.png",
				id: "star4"
			},

			// humans
			{
				src: window.links.baseUrl + "/images/cars/pedestrian.png",
				id: "pedestrian1"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian2.png",
				id: "pedestrian2"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian3.png",
				id: "pedestrian3"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian4.png",
				id: "pedestrian4"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian5.png",
				id: "pedestrian5"
			}, {
				src: window.links.baseUrl + "/images/cars/pedestrian6.png",
				id: "pedestrian6"
			},

			// other moving sprites
			{
				src: window.links.baseUrl + "/images/cars/chmura1.png",
				id: "chmura1"
			}, {
				src: window.links.baseUrl + "/images/cars/chmura2.png",
				id: "chmura2"
			}, {
				src: window.links.baseUrl + "/images/cars/chmura3.png",
				id: "chmura3"
			}, {
				src: window.links.baseUrl + "/images/cars/chmura4.png",
				id: "chmura4"
			}, {
				src: window.links.baseUrl + "/images/cars/samolot.png",
				id: "samolot"
			}, {
				src: window.links.baseUrl + "/images/cars/lodka.png",
				id: "lodka"
			},

			// buildings ----------
			// -- agencje reklamowe
			{
				src: window.links.baseUrl + "/images/buildings/agencjeReklamowe/agencjaReklamowa1.png",
				id: "agencjaReklamowa1"
			}, {
				src: window.links.baseUrl + "/images/buildings/agencjeReklamowe/agencjaReklamowa2.png",
				id: "agencjaReklamowa2"
			}, {
				src: window.links.baseUrl + "/images/buildings/agencjeReklamowe/agencjaReklamowa3.png",
				id: "agencjaReklamowa3"
			},
			// -- banki
			{
				src: window.links.baseUrl + "/images/buildings/banki/bank1.png",
				id: "bank1"
			}, {
				src: window.links.baseUrl + "/images/buildings/banki/bank2.png",
				id: "bank2"
			}, {
				src: window.links.baseUrl + "/images/buildings/banki/bank3.png",
				id: "bank3"
			}, {
				src: window.links.baseUrl + "/images/buildings/banki/bank4.png",
				id: "bank4"
			},
			// -- centra szkoleniwe
			{
				src: window.links.baseUrl + "/images/buildings/centraSzkoleniowe/centrumSzkoleniowe1.png",
				id: "centrumSzkoleniowe1"
			}, {
				src: window.links.baseUrl + "/images/buildings/centraSzkoleniowe/centrumSzkoleniowe2.png",
				id: "centrumSzkoleniowe2"
			}, {
				src: window.links.baseUrl + "/images/buildings/centraSzkoleniowe/centrumSzkoleniowe3.png",
				id: "centrumSzkoleniowe3"
			}, {
				src: window.links.baseUrl + "/images/buildings/centraSzkoleniowe/centrumSzkoleniowe4.png",
				id: "centrumSzkoleniowe4"
			},
			// -- urzedy skarbowe
			{
				src: window.links.baseUrl + "/images/buildings/urzedySkarbowe/urzadSkarbowy1.png",
				id: "urzadSkarbowy1"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzedySkarbowe/urzadSkarbowy2.png",
				id: "urzadSkarbowy2"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzedySkarbowe/urzadSkarbowy3.png",
				id: "urzadSkarbowy3"
			},
			// -- pozostale urzedy
			{
				src: window.links.baseUrl + "/images/buildings/agencjaPosrednictwaPracy.png",
				id: "agencjaPosrednictwaPracy"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzadMiasta.png",
				id: "urzadMiasta"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzadPracy.png",
				id: "urzadPracy"
			}, {
				src: window.links.baseUrl + "/images/buildings/urzadStatystyczny.png",
				id: "urzadStatystyczny"
			}, {
				src: window.links.baseUrl + "/images/buildings/zus.png",
				id: "zus"
			},

			// -- statyczne budynki
			{
				src: window.links.baseUrl + "/images/buildings/statyczne/most.png",
				id: "most"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/zaing.png",
				id: "zaing"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/zamek.png",
				id: "zamek"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/domek1.png",
				id: "domek1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/domek2.png",
				id: "domek2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/domek3.png",
				id: "domek3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/hangar.png",
				id: "hangar"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/kosciol1.png",
				id: "kosciol1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/kosciol2.png",
				id: "kosciol2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/skala-down.png",
				id: "skala-down"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/skala-down-left.png",
				id: "skala-down-left"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/skala-right.png",
				id: "skala-right"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/skala-up.png",
				id: "skala-up"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/politechnika1.png",
				id: "politechnika1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/politechnika2.png",
				id: "politechnika2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/lotnisko.png",
				id: "lotnisko"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drogowskaz.png",
				id: "drogowskaz"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/latarnia_left.png",
				id: "latarniaL"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/latarnia_right.png",
				id: "latarniaR"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-mid.png",
				id: "drzewka-pn-mid"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn.png",
				id: "drzewka-pn"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-wsch-1.png",
				id: "drzewka-pn-wsch-1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-wsch-2.png",
				id: "drzewka-pn-wsch-2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-wsch-3.png",
				id: "drzewka-pn-wsch-3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-wsch-4.png",
				id: "drzewka-pn-wsch-4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pn-zach.png",
				id: "drzewka-pn-zach"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-podsaskim.png",
				id: "drzewka-podsaskim"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-saski1.png",
				id: "drzewka-saski1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-saski2.png",
				id: "drzewka-saski2"
			},

			{
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zus.png",
				id: "drzewka-zus"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach.png",
				id: "drzewka-zach"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach2.png",
				id: "drzewka-zach2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach3.png",
				id: "drzewka-zach3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach4.png",
				id: "drzewka-zach4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach5.png",
				id: "drzewka-zach5"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach6.png",
				id: "drzewka-zach6"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach7.png",
				id: "drzewka-zach7"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach-mid1.png",
				id: "drzewka-zach-mid1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach-mid2.png",
				id: "drzewka-zach-mid2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-zach-mid3.png",
				id: "drzewka-zach-mid3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-center1.png",
				id: "drzewka-center1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-center2.png",
				id: "drzewka-center2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most1.png",
				id: "drzewka-most1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most2.png",
				id: "drzewka-most2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most3.png",
				id: "drzewka-most3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most4.png",
				id: "drzewka-most4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-most5.png",
				id: "drzewka-most5"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-side-autostrada.png",
				id: "drzewka-side-autostrada"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada1.png",
				id: "drzewka-autostrada1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada2.png",
				id: "drzewka-autostrada2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada3.png",
				id: "drzewka-autostrada3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada4.png",
				id: "drzewka-autostrada4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada5.png",
				id: "drzewka-autostrada5"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada6.png",
				id: "drzewka-autostrada6"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-autostrada7.png",
				id: "drzewka-autostrada7"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd1.png",
				id: "drzewka-pd1"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd2.png",
				id: "drzewka-pd2"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd3.png",
				id: "drzewka-pd3"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd4.png",
				id: "drzewka-pd4"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd5.png",
				id: "drzewka-pd5"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd6.png",
				id: "drzewka-pd6"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd7.png",
				id: "drzewka-pd7"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd8.png",
				id: "drzewka-pd8"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd9.png",
				id: "drzewka-pd9"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd10.png",
				id: "drzewka-pd10"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd11.png",
				id: "drzewka-pd11"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd12.png",
				id: "drzewka-pd12"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd13.png",
				id: "drzewka-pd13"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-pd14.png",
				id: "drzewka-pd14"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/drzewka-ing.png",
				id: "drzewka-ing"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/przystanek.png",
				id: "przystanek"
			}, {
				src: window.links.baseUrl + "/images/buildings/statyczne/kosz.png",
				id: "kosz"
			},

			// -- biura
			{
				src: window.links.baseUrl + "/images/buildings/biura/biuro1.png",
				id: "biuro1"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro2.png",
				id: "biuro2"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro3.png",
				id: "biuro3"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro4.png",
				id: "biuro4"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro5.png",
				id: "biuro5"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro6.png",
				id: "biuro6"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro7.png",
				id: "biuro7"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro8.png",
				id: "biuro8"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro9.png",
				id: "biuro9"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro10.png",
				id: "biuro10"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro11.png",
				id: "biuro11"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro12.png",
				id: "biuro12"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro13.png",
				id: "biuro13"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro14.png",
				id: "biuro14"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro15.png",
				id: "biuro15"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro15b.png",
				id: "biuro15b"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro16.png",
				id: "biuro16"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro17.png",
				id: "biuro17"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro18.png",
				id: "biuro18"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro19.png",
				id: "biuro19"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro20.png",
				id: "biuro20"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro21.png",
				id: "biuro21"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro22.png",
				id: "biuro22"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro23.png",
				id: "biuro23"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro24.png",
				id: "biuro24"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro25.png",
				id: "biuro25"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro26.png",
				id: "biuro26"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro27.png",
				id: "biuro27"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro28.png",
				id: "biuro28"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro28b.png",
				id: "biuro28b"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro29.png",
				id: "biuro29"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro30.png",
				id: "biuro30"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro31.png",
				id: "biuro31"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro32.png",
				id: "biuro32"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro33.png",
				id: "biuro33"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro34.png",
				id: "biuro34"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro35.png",
				id: "biuro35"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro36.png",
				id: "biuro36"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro37.png",
				id: "biuro37"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro38.png",
				id: "biuro38"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro39.png",
				id: "biuro39"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro40.png",
				id: "biuro40"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro41.png",
				id: "biuro41"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro42.png",
				id: "biuro42"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro43.png",
				id: "biuro43"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro44.png",
				id: "biuro44"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro45.png",
				id: "biuro45"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro46.png",
				id: "biuro46"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro47.png",
				id: "biuro47"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro48.png",
				id: "biuro48"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro49.png",
				id: "biuro49"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro50.png",
				id: "biuro50"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro51.png",
				id: "biuro51"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro52.png",
				id: "biuro52"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro53.png",
				id: "biuro53"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro54.png",
				id: "biuro54"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro55.png",
				id: "biuro55"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro56.png",
				id: "biuro56"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro57.png",
				id: "biuro57"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro58.png",
				id: "biuro58"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro59.png",
				id: "biuro59"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/biuro60.png",
				id: "biuro60"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/elpro.png",
				id: "biuroElpro"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/pyramid.png",
				id: "biuroPyramid"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/metropolian.png",
				id: "metropolian"
			}, {
				src: window.links.baseUrl + "/images/buildings/biura/ing.png",
				id: "ing"
			},

			// interiors ----------
			// -- agencje reklamowe
			{
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa1.jpg",
				id: "intAR1"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa1_rozmowa.jpg",
				id: "intAR1r"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa2.jpg",
				id: "intAR2"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa2_rozmowa.jpg",
				id: "intAR2r"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa3.jpg",
				id: "intAR3"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/agencjaReklamowa3_rozmowa.jpg",
				id: "intAR3r"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/active/ar1a.png",
				id: "ar1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/active/ar2a.png",
				id: "ar2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjeReklamowe/active/ar3a.png",
				id: "ar3aImg"
			},
			// -- banki
			{
				src: window.links.baseUrl + "/images/interiors/banki/bank1.jpg",
				id: "intBank1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank1_rozmowa1.jpg",
				id: "intBank1r1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank1_rozmowa2.jpg",
				id: "intBank1r2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank2.jpg",
				id: "intBank2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank2_rozmowa1.jpg",
				id: "intBank2r1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank2_rozmowa2.jpg",
				id: "intBank2r2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank3.jpg",
				id: "intBank3"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank3_rozmowa1.jpg",
				id: "intBank3r1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank3_rozmowa2.jpg",
				id: "intBank3r2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank4.jpg",
				id: "intBank4"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank4_2.jpg",
				id: "intBank4_2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank4_rozmowa1.jpg",
				id: "intBank4r1"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/bank4_rozmowa2.jpg",
				id: "intBank4r2"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b1a.png",
				id: "b1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b4a.png",
				id: "b4aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b2r1a.png",
				id: "b2r1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b2r2a.png",
				id: "b2r2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b3r1a.png",
				id: "b3r1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b3r2a.png",
				id: "b3r2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b4r1a.png",
				id: "b4r1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/banki/active/b4r2a.png",
				id: "b4r2aImg"
			},

			// -- centra szkoleniowe
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1.jpg",
				id: "intCS1"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_biurko.jpg",
				id: "intCS1b"
			},
			//{src: window.links.baseUrl+"/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_egzamin.jpg", id:"intCS1e"},
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_szkoleniowa.jpg",
				id: "intCS1e"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_rozmowa.jpg",
				id: "intCS1r"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe1_tablica.jpg",
				id: "intCS1s"
			}, //szkolenie
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe2.jpg",
				id: "intCS2"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe2_biurko.jpg",
				id: "intCS2b"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe2_szkoleniowa.jpg",
				id: "intCS2e"
			}, // egzamin.jpg , szkoleniowa.jpg
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe2_tablica.jpg",
				id: "intCS2s"
			}, //szkolenie
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3.jpg",
				id: "intCS3"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3_biurko.jpg",
				id: "intCS3b"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3_szkolenie.jpg",
				id: "intCS3e"
			}, // egzamin
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3_rozmowa.jpg",
				id: "intCS3r"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe3_biurko.jpg",
				id: "intCS3s"
			}, //szkolenie
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4.jpg",
				id: "intCS4"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4_biurko.jpg",
				id: "intCS4b"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4_egzamin.jpg",
				id: "intCS4e"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4_rozmowa.jpg",
				id: "intCS4r"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/centrumSzkoleniowe4_tablica.jpg",
				id: "intCS4s"
			}, //szkolenie
			{
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/active/cs1a.png",
				id: "cs1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/active/cs3a.png",
				id: "cs3aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/centraSzkoleniowe/active/cs4a.png",
				id: "cs4aImg"
			},
			// -- urzedy skarbowe
			{
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/urzadSkarbowy.jpg",
				id: "intUS"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/urzadSkarbowy_rozmowa1.jpg",
				id: "intUSr1"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/urzadSkarbowy_rozmowa2.jpg",
				id: "intUSr2"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/urzadSkarbowy_stolik.jpg",
				id: "intUSs"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/active/usr1a.png",
				id: "usr1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzedySkarbowe/active/usr2a.png",
				id: "usr2aImg"
			},
			// -- urzad pracy
			{
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy.jpg",
				id: "intUP"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy_rozmowa1.jpg",
				id: "intUPr1"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy_rozmowa2.jpg",
				id: "intUPr2"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy_stolik.jpg",
				id: "intUPs"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/urzadPracy_terminal.jpg",
				id: "intUPt"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/upta.png",
				id: "uptaImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/upn1a.png",
				id: "upn1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/upn2a.png",
				id: "upn2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/uptp1a.png",
				id: "uptp1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/urzadPracy/active/uptp2a.png",
				id: "uptp2aImg"
			},
			// -- agencja posrednictwa pracy
			{
				src: window.links.baseUrl + "/images/interiors/agencjaPP/agencjaPP.jpg",
				id: "intAPP"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjaPP/agencjaPP_rozmowa1.jpg",
				id: "intAPPr1"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjaPP/agencjaPP_rozmowa2.jpg",
				id: "intAPPr2"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjaPP/active/appr1a.png",
				id: "appr1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/agencjaPP/active/appr2a.png",
				id: "appr2aImg"
			},
			// -- zus
			{
				src: window.links.baseUrl + "/images/interiors/zus/zus.jpg",
				id: "intZ"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/zus_rozmowa1.jpg",
				id: "intZr1"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/zus_rozmowa2.jpg",
				id: "intZr2"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/zus_stolik.jpg",
				id: "intZs"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/zus_terminal.jpg",
				id: "intZt"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zustp1a.png",
				id: "zustp1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zustp2a.png",
				id: "zustp2aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zusta.png",
				id: "zustaImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zusn1a.png",
				id: "zusn1aImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/zus/active/zusn2a.png",
				id: "zusn2aImg"
			},
			// -- biura
			{
				src: window.links.baseUrl + "/images/interiors/biura/treeSprite.png",
				id: "treeSprite"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuro.png",
				id: "biuroGracza"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroTlo.jpg",
				id: "biuroTlo"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroZlecenia1.jpg",
				id: "biuroZlecenia1"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroZlecenia1_rozmowa.jpg",
				id: "biuroZlecenia1r"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroZlecenia2.jpg",
				id: "biuroZlecenia2"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/biuroZlecenia2_rozmowa.jpg",
				id: "biuroZlecenia2r"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/komputer.png",
				id: "komputerSprite"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/komputerScreen.jpg",
				id: "komputerScreen"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/active/bz1ra.png",
				id: "bz1raImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/active/bz2ra.png",
				id: "bz2raImg"
			},

			{
				src: window.links.baseUrl + "/images/interiors/biura/browser_close.jpg"
			}, {
				src: window.links.baseUrl + "/images/interiors/biura/browser_close_hover.jpg"
			},
			// -- pozostale wnetrza
			{
				src: window.links.baseUrl + "/images/interiors/biurko.jpg",
				id: "biurko"
			}, {
				src: window.links.baseUrl + "/images/interiors/komputer.jpg",
				id: "komputer"
			}, {
				src: window.links.baseUrl + "/images/interiors/terminal.jpg",
				id: "terminal"
			},
			// elementy wnetrz
			{
				src: window.links.baseUrl + "/images/interiors/blank.png",
				id: "blankImg"
			}, {
				src: window.links.baseUrl + "/images/interiors/strzalka.png",
				id: "strzalkaImg"
			},

			// also preload some gui elements
			{
				src: window.links.baseUrl + "/images/gui/symbol-punkty.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-bank.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-biuro.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-finanse.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-firma.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-hide-minimap.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-info.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-komputer.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-kontrahenci.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-marketing.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-pliki.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-pracownicy.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-punkty.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-show-minimap.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-skrzynka.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-stat.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-statystyki.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-szkolenia.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-ue.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-urzadpracy.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-urzadskarbowy.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-wyjscie.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-zlecenia.png"
			}, {
				src: window.links.baseUrl + "/images/gui/symbol-zus.png"
			}, {
				src: window.links.baseUrl + "/images/gui/update.png"
			}, {
				src: window.links.baseUrl + "/images/maps/minimap1.jpg"
			}, {
				src: window.links.baseUrl + "/images/gui/biologia.png"
			}, {
				src: window.links.baseUrl + "/images/gui/biologia_small.png"
			}, {
				src: window.links.baseUrl + "/images/gui/biologia_small_grey.png"
			}, {
				src: window.links.baseUrl + "/images/gui/chemia.png"
			}, {
				src: window.links.baseUrl + "/images/gui/chemia_small.png"
			}, {
				src: window.links.baseUrl + "/images/gui/chemia_small_grey.png"
			}, {
				src: window.links.baseUrl + "/images/gui/matematyka.png"
			}, {
				src: window.links.baseUrl + "/images/gui/matematyka_small.png"
			}, {
				src: window.links.baseUrl + "/images/gui/matematyka_small_grey.png"
			}, {
				src: window.links.baseUrl + "/images/gui/fizyka.png"
			}, {
				src: window.links.baseUrl + "/images/gui/fizyka_small.png"
			}, {
				src: window.links.baseUrl + "/images/gui/fizyka_small_grey.png"
			}, {
				src: window.links.baseUrl + "/images/gui/bottom_bar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/info_bar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/button_bg.png"
			}, {
				src: window.links.baseUrl + "/images/gui/clock_bar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/empty-avatar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/fire-button.png"
			}, {
				src: window.links.baseUrl + "/images/gui/info-icon.png"
			}, {
				src: window.links.baseUrl + "/images/gui/info-icon-sm.png"
			}, {
				src: window.links.baseUrl + "/images/gui/lesson_bar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/loadingbar.png"
			}, {
				src: window.links.baseUrl + "/images/gui/loading.png"
			}, {
				src: window.links.baseUrl + "/images/gui/loading_bg.jpg"
			}, {
				src: window.links.baseUrl + "/images/gui/logo.png"
			}, {
				src: window.links.baseUrl + "/images/gui/logo-tlo.png"
			}, {
				src: window.links.baseUrl + "/images/gui/money-icon.png"
			}, {
				src: window.links.baseUrl + "/images/gui/panel-gorny.png"
			}, {
				src: window.links.baseUrl + "/images/gui/pasek.png"
			}, {
				src: window.links.baseUrl + "/images/gui/pointer.png"
			}, {
				src: window.links.baseUrl + "/images/gui/przycisk.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar_bg.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar_header.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar_hider.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar_leftborder.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar-expanded.png"
			}, {
				src: window.links.baseUrl + "/images/gui/sidebar-zwiniety.png"
			},

			// loga
			{
				src: window.links.baseUrl + "/images/loga/loga_agencjeReklamowe/agencjaReklamowa1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_agencjeReklamowe/agencjaReklamowa2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_agencjeReklamowe/agencjaReklamowa3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_banki/bank1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_banki/bank2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_banki/bank3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_banki/bank4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_centraSzkoleniowe/centrumSzkoleniowe1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_centraSzkoleniowe/centrumSzkoleniowe2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_centraSzkoleniowe/centrumSzkoleniowe3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_centraSzkoleniowe/centrumSzkoleniowe4.png"
			},

			// loga do kupienia
			{
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo6.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo7.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo8.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo9.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/biologia/logo10.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo6.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo7.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo8.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo9.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/chemia/logo10.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo6.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo7.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo8.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo9.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/fizyka/logo10.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo1.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo2.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo3.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo4.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo5.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo6.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo7.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo8.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo9.png"
			}, {
				src: window.links.baseUrl + "/images/loga/loga_firmy/matematyka/logo10.png"
			},

			// other gui icons
			{
				src: window.links.baseUrl + "/images/gui/refresh.png"
			}, {
				src: window.links.baseUrl + "/images/gui/flag_en.gif"
			}, {
				src: window.links.baseUrl + "/images/gui/flag_pl.gif"
			}
		];

		this.preloader = new createjs.LoadQueue();

		// registering events
		var gameObject = this;
		var tickHandler = this.tick;
		var resizeHandler = this.resize;
		var keyboardHandler = this.keyboard;
		var progressHandler = this.loadProgress;
		var loadHandler = this.loadComplete;
		var hashHandler = this.parseUrl;
		createjs.Ticker.addEventListener("tick", function(event) {
			tickHandler.call(gameObject, event);
		});
		// createjs.Ticker.setFPS(20); // default is 20
		window.addEventListener("resize", function(event) {
			resizeHandler.call(gameObject, event);
		}, false);

		var pre = this.preloader;

		pre.addEventListener("progress", function(event) {
			progressHandler.call(gameObject, event);
		});
		pre.addEventListener("complete", function(event) {
			loadHandler.call(gameObject, event);
		});
		// pre.addEventListener("error", function(event)    { pre.loadFile({ src: event.item.src, id: event.item.id }); });

		document.addEventListener("keydown", function(event) {
			keyboardHandler.call(gameObject, event);
		});
		this.canvas.addEventListener("mousemove", function(event) {
			gameObject.mouseOldPos = {
				x: gameObject.mousePos.x,
				y: gameObject.mousePos.y
			};
			gameObject.mousePos = {
				x: event.pageX,
				y: event.pageY
			};
		});
		document.addEventListener("mouseout", function(event) {
			gameObject.mousePos = {
				x: 300,
				y: 300
			};
			gameObject.mouseOldPos = {
				x: 300,
				y: 300
			};
		});
		window.addEventListener("hashchange", function() {
			hashHandler.call(gameObject);
		});

		// create tooltip DOM element on canvas to capture clicks
		//var tooltip = document.getElementById("gameTooltip");
		//this.tooltipElement = new createjs.DOMElement(tooltip);
		var tooltip = this.tooltipElement;
		$(".gameTooltip").each(function() {
			var element = new createjs.DOMElement(this);
			tooltip.push(element);
		});

		// final setup
		this.resize();
		window.stage = this.stage;

		// load all assets
		this.preloader.loadManifest(this.manifest);

		//add global focus events to block map movements
		var thisGame = this;
		jQuery(document).on('focusin', function() {
			thisGame._enableMapMovement = false;
		});
		jQuery(document).on('focusout', function() {
			thisGame._enableMapMovement = true;
		});
	}
};

Game.prototype.resize = function() {
	var context = this.canvas.getContext("2d");
	var screenImage = context.getImageData(0, 0, this.canvas.width, this.canvas.height);

	this.canvas.width = window.innerWidth;
	this.canvas.height = window.innerHeight; //-70;

	this.scaleInterior();
	if (this.currentInterior != -1) {
		this.interiors[this.currentInterior].container.x = 0;
		this.interiors[this.currentInterior].container.y = 0;
	}

	context.putImageData(screenImage, 0, 0);
};

Game.prototype.tick = function(event) {
	if (this.map)
		this.map.traffic.handleTraffic();
	this.scrollTick();

	this.stage.update(event);
};

Game.prototype.scrollTick = function() {
	// smooth scrolling of containers
	if (this.scrollable == true && this.container != null && this.map != null && this.mousePos != this.mouseOldPos) {
		var c = this.container;
		var i, w, h;
		if (this.currentInterior == -1) {
			i = this.map.getImage();
			w = i.width - this.canvas.width;
			h = i.height - this.canvas.height;
		} else {
			i = this.interiors[this.currentInterior].image;
			s = this.getScaleInterior();
			w = (i.width * s) - this.canvas.width;
			h = (i.height * s) - this.canvas.height;
		}

		var mp = this.mousePos;
		var distanceFromBorder = 200;
		var maxScrollingSpeed = 30;

		if (mp.x < distanceFromBorder) {
			var change = 100 / mp.x;
			if (change > maxScrollingSpeed || change <= 0) change = maxScrollingSpeed;
			c.x += change;
			if (c.x > 0) c.x = 0;
		}
		if (this.currentInterior == -1 && mp.y - 27 < distanceFromBorder) // -27 is header size
		{
			var change = 100 / (mp.y - 27);
			if (change > maxScrollingSpeed || change <= 0) change = maxScrollingSpeed;
			c.y += change;
			if (c.y > 0) c.y = 0;
		}
		if (mp.x > this.canvas.width - distanceFromBorder) {
			var change = 100 / (this.canvas.width - mp.x);
			if (change > maxScrollingSpeed || change <= 0) change = maxScrollingSpeed;
			c.x -= change;
			if (c.x < -w) c.x = -w;
		}
		if (this.currentInterior == -1 && mp.y > this.canvas.height - distanceFromBorder) {
			var change = 100 / (this.canvas.height - mp.y);
			if (change > maxScrollingSpeed || change <= 0) change = maxScrollingSpeed;
			c.y -= change;
			if (c.y < -h) c.y = -h;
		}
		if (this.currentInterior == -1) this.updateMinimap();
	}
};

Game.prototype.loadProgress = function(event) {
	var size = this.preloader.progress * 620;
	$("#loadingbar").css("width", this.preloader.progress * 620 + "px");
}

Game.prototype.loadComplete = function(event) {
	var gameObject = this;
	var interior;
	var resname;
	var res;

	// create map
	this.map = new Map(gameObject);
	var image = this.preloader.getResult("cityImg");
	this.map.init(image);

	// humans, pedestrians
	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian2";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian3";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian4";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian5";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);

	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian2";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian3";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian4";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian5";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);

	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian2";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian3";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian4";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian5";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian1";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian2";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian3";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian4";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian5";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	resname = "pedestrian6";
	res = this.preloader.getResult(resname);
	this.map.addPedestrian(resname, res, 14, 18, 100);
	/*
		resname = "pedestrian1"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian2"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian3"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian4"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian5"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian6"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian1"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian2"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian3"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
		resname = "pedestrian4"; res = this.preloader.getResult(resname); this.map.addPedestrian(resname,res, 14, 18, 100);
	*/
	// add cars
	var rc = this.map.traffic.roadCount;
	var carnum = 17;

	for (i = 0; i < this.map.traffic.roads.length; i++) {
		if (i % carnum == 0) {
			resname = "trolejbus";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 61, 57);
		}
		if (i % carnum == 1) {
			resname = "trolejbus";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 61, 57);
		}
		if (i % carnum == 2) {
			resname = "trolejbus";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 61, 57);
		}
		if (i % carnum == 3) {
			resname = "trolejbus";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 61, 57);
		}
		if (i % carnum == 4) {
			resname = "chevrolet";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 38, 26);
		}
		if (i % carnum == 5) {
			resname = "chevrolet2";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 38, 26);
		}
		if (i % carnum == 6) {
			resname = "chevrolet3";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 38, 26);
		}
		if (i % carnum == 7) {
			resname = "chevrolet4";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 38, 26);
		}
		if (i % carnum == 8) {
			resname = "porsche";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 37, 29);
		}
		if (i % carnum == 9) {
			resname = "porsche2";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 37, 29);
		}
		if (i % carnum == 10) {
			resname = "porsche3";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 37, 29);
		}
		if (i % carnum == 11) {
			resname = "porsche4";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 37, 29);
		}
		if (i % carnum == 12) {
			resname = "smart";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 23, 23);
		}
		if (i % carnum == 13) {
			resname = "smart2";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 23, 23);
		}
		if (i % carnum == 14) {
			resname = "smart3";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 23, 23);
		}
		if (i % carnum == 15) {
			resname = "smart4";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 23, 23);
		}
		if (i % carnum == 16) {
			resname = "star";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 45, 37);
		}
		if (i % carnum == 17) {
			resname = "star2";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 45, 37);
		}
		if (i % carnum == 18) {
			resname = "star3";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 45, 37);
		}
		if (i % carnum == 19) {
			resname = "star4";
			res = this.preloader.getResult(resname);
			this.map.addCar(resname, res, 45, 37);
		}
	}

	this.map.traffic.showLines();

	resname = "lodka";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 34, 50, 100); // 42 52 // it's a boat actually, just pretending to be a cloud
	resname = "lodka";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname + "-2", res, 34, 50, 100);
	resname = "samolot";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 100, 70, 10); // it's a plane actually, just pretending to be a cloud

	// latarnie polnocny-zachod
	resname = "latarniaL";
	res = this.preloader.getResult(resname);
	for (i = 0; i < 11; i++)
		this.map.addBuilding(resname, res, -42 + (i * 73), 995 - (i * 42), false);
	for (i = 11; i < 23; i++)
		this.map.addBuilding(resname, res, -70 + (i * 73), 1011 - (i * 42), false);

	// latarnie poludnie
	for (i = 0; i < 17; i++)
		this.map.addBuilding(resname, res, 1337 + (i * 73), 2061 - (i * 42), false);
	for (i = 17; i < 28; i++)
		this.map.addBuilding(resname, res, 1345 + (i * 73), 2053 - (i * 42), false);
	for (i = 28; i < 36; i++)
		this.map.addBuilding(resname, res, 1400 + (i * 73), 2010 - (i * 42), false);

	// latarnie wschod
	resname = "latarniaR";
	res = this.preloader.getResult(resname);
	for (i = 0; i < 10; i++)
		this.map.addBuilding(resname, res, 1794 + (i * 73), -45 + (i * 42), false);
	for (i = 10; i < 14; i++)
		this.map.addBuilding(resname, res, 1850 + (i * 73), -12 + (i * 42), false);
	for (i = 14; i < 20; i++)
		this.map.addBuilding(resname, res, 1908 + (i * 73), 22 + (i * 42), false);
	for (i = 20; i < 27; i++)
		this.map.addBuilding(resname, res, 2000 + (i * 73), 78 + (i * 42), false);

	// biura przed aktywnymi budynkami
	resname = "biuro33";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 932, 780);
	resname = "biuro34";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1170, 890);

	// static before buildings
	resname = "drzewka-zach";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 0, 1050, false);
	resname = "drzewka-zach2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 604, 1382, false);
	resname = "drzewka-zach3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 728, 1300, false);
	resname = "drzewka-zach4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 887, 1278, false);
	resname = "drzewka-zach5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 967, 1333, false);
	resname = "drzewka-zach6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1084, 1402, false);
	resname = "drzewka-zach7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1149, 1433, false);
	resname = "drzewka-zach-mid1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 425, 846, false);
	resname = "drzewka-zach-mid2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 586, 742, false);
	resname = "drzewka-zach-mid3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 691, 662, false);
	resname = "drzewka-center1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1498, 1268, false);
	resname = "drzewka-center2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1616, 1188, false);
	resname = "drzewka-side-autostrada";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2497, 507, false);
	resname = "drzewka-most1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1925, 1056, false);
	resname = "drzewka-most2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2007, 1109, false);
	resname = "drzewka-most3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2056, 1123, false);
	resname = "drzewka-most4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2053, 1237, false);
	resname = "drzewka-most5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2389, 1319, false);
	resname = "drzewka-autostrada1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2626, 529, false);
	resname = "drzewka-autostrada2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2780, 624, false);
	resname = "drzewka-autostrada3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3081, 791, false);
	resname = "drzewka-autostrada4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3217, 862, false);
	resname = "drzewka-autostrada5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3538, 1060, false);
	resname = "drzewka-autostrada6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2582, 1091, false);
	resname = "drzewka-autostrada7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3690, 1155, false);
	resname = "drzewka-pd1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1542, 1066, false);
	resname = "drzewka-pd2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1671, 2019, false);
	resname = "drzewka-pd3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1767, 1959, false);
	resname = "drzewka-pd4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1911, 1813, false);
	resname = "drzewka-pd5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2115, 1714, false);
	resname = "drzewka-pd6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2259, 1621, false);
	resname = "drzewka-pd7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2397, 1597, false);
	resname = "drzewka-pd8";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2457, 1538, false);
	resname = "drzewka-pd9";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2548, 1466, false);
	resname = "drzewka-pd10";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2711, 1417, false);
	resname = "drzewka-pd11";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2800, 1339, false);
	resname = "drzewka-pd12";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2953, 1210, false);
	resname = "drzewka-pd13";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3155, 1112, false);
	resname = "drzewka-pd14";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3295, 1019, false);
	resname = "drzewka-ing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 649, 1123, false);
	resname = "drzewka-ing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1488, 1205, false);

	// add active buildings
	resname = "agencjaReklamowa1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 625, 965);
	resname = "agencjaReklamowa2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1420, 390);
	resname = "agencjaReklamowa3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 500, 500);

	resname = "bank1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 848, 766); //2718,555); //1900,1400);
	resname = "bank2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2080, 710);
	resname = "bank3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2360, 368); //2075, 705);
	resname = "bank4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1525, 456); // 1540,435 1510, 450

	resname = "centrumSzkoleniowe1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1665, 789);
	resname = "centrumSzkoleniowe2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 333, 538);
	resname = "centrumSzkoleniowe3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2700, 1340); // 1790,1364  //2922,499);
	resname = "centrumSzkoleniowe4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2900, 495);

	resname = "urzadSkarbowy1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1883, 639);
	resname = "urzadSkarbowy2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2575, 262);
	resname = "urzadSkarbowy3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2027, 943);

	resname = "urzadStatystyczny";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2113, 291, true, true); // not clickable, only hover
	resname = "urzadPracy";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2535, 461);
	resname = "zus";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 979, 916);

	// static one
	resname = "zaing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 689, 1054, false);

	// biura za aktywnymi
	resname = "metropolian";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 649, 1062);
	resname = "ing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 895, 1085);

	resname = "biuro37";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 72, 477);
	resname = "biuro28b";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 176, 520);
	resname = "biuro5";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 510, 535); // 605 512
	resname = "biuro27";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 15, 610);
	resname = "biuro26";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 120, 695);
	resname = "biuro18";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 659, 651);
	resname = "biuro13";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 881, 659);
	resname = "biuro14";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 264, 952);
	resname = "biuro57";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 300, 994);
	resname = "biuro32";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 492, 1088);
	resname = "biuro44";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 598, 1139, false); // deactivated
	resname = "biuro23";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 175, 1047);
	resname = "biuro13";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 331, 1165);
	resname = "biuro11";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 484, 1146, false); // deactivated
	resname = "biuro22";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 408, 1184, false); // deactivated
	resname = "biuro20";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 309, 1268, false); // deactivated
	resname = "biuro18";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 376, 1344, false); // deactivated
	resname = "biuro10";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 547, 1225);

	resname = "biuro29";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1130, 1210);
	resname = "biuro28b";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 932, 1177);
	resname = "biuro28";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1030, 1206, false); // deactivated
	resname = "biuro28";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1128, 1270);
	resname = "biuro31";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1233, 1267, false); // deactivated
	resname = "biuro29";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1148, 1310);
	resname = "biuro28";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 1211, 1319, false); // deactivated

	resname = "biuro42";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1390, 978);
	resname = "biuro28";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 1317, 1003);
	resname = "biuro15b";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1142, 1034, false); // deactivated
	resname = "biuro58";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1382, 1022, false); // deactivated
	resname = "biuro15";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1450, 1048, false); // deactivated

	resname = "biuro21";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1320, 1094, false); // deactivated
	resname = "biuro12";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1383, 1199, false); // deactivated
	resname = "biuro51";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1126, 674);
	resname = "biuro46";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1138, 709);

	resname = "biuro10";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1059, 404);
	resname = "biuro16";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1230, 324);
	resname = "biuro14";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1340, 402);
	resname = "biuro20";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1222, 386);
	resname = "biuro25";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1346, 481);
	resname = "biuro24";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1271, 558, false); // deactivated

	resname = "biuro34";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1641, 564);
	resname = "biuro48";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1510, 698);
	resname = "biuro8";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1450, 708);
	resname = "biuro1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1390, 730);

	resname = "biuro7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1525, 884);
	resname = "biuro2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1662, 975);
	resname = "biuro43";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1848, 1119);
	resname = "biuro48";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1888, 1067);

	resname = "biuro6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1900, 868);
	resname = "biuro55";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2182, 895);
	resname = "biuro42";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2190, 980);
	resname = "biuro42";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2270, 866, false); // deactivated

	resname = "biuro54";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2872, 660);
	resname = "biuro51";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2955, 683);
	resname = "biuro50";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2809, 700);
	resname = "biuro52";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2742, 737);
	resname = "biuro50";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2675, 776);
	resname = "biuro53";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2638, 812);

	resname = "biuro1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2460, 550, false); // deactivated);

	resname = "biuro54";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2390, 531);
	resname = "biuro53";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2361, 567);
	resname = "biuro53";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2422, 600);

	resname = "kosciol2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2286, 550, false); // non active

	resname = "biuro51";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2268, 621, false); // deactivated
	resname = "biuro51";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 2329, 654, false); // deactivated

	resname = "biuro50";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2465, 635);
	resname = "biuro50";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 2397, 674);

	resname = "biuro49";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2221, 650, false); // deactivated
	resname = "biuro53";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 2174, 675, false); // deactivated
	resname = "biuro52";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2267, 697, false); // 2265,699 // 2257,705 // 2260,700 // deactivated
	resname = "biuro45";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2270, 724);

	resname = "biuro49";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2718, 554);
	resname = "biuro56";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2559, 612, false); // deactivated
	resname = "biuro60";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2723, 350);
	resname = "biuro9";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2756, 397);

	resname = "biuro4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2270, 398);
	resname = "biuro47";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2144, 517);

	// osiedla polnocne
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1609, 16);
	resname = "biuro19";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1668, 26);
	resname = "biuro21";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1753, 15, false); // deactivated
	resname = "biuro18";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 1831, 67, false); // deactivated
	resname = "biuro23";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1923, 114, false); // deactivated
	resname = "biuro24";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2078, 134, false); // deactivated
	resname = "biuro12";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 1993, 223);

	// osiedla polodniowe
	resname = "biuro26";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2969, 1239, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2923, 1469, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-3", res, 2656, 1513, false); // deactivated
	resname = "biuro59";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2656, 1571);
	resname = "biuro25";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-2", res, 2769, 1540, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-4", res, 2022, 1517, false); // deactivated
	resname = "biuro41";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1567, 1635, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-5", res, 1477, 1660, false); // deactivated

	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-6", res, 540, 1555, false); // deactivated
	resname = "biuro39";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname + "-7", res, 862, 1532, false); // deactivated

	resname = "biuroElpro";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3682, 872);
	resname = "biuroPyramid";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3017, 573);

	// aktywne budynki za biurami
	resname = "agencjaPosrednictwaPracy";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2443, 678);
	resname = "urzadMiasta";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2408, 749, true, true);

	// add non-active buildings
	resname = "most";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2141, 1132, false);
	resname = "zamek";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2850, 700, false);
	resname = "domek1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1638, 1703, false);
	resname = "domek2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2577, 1577, false);
	resname = "domek3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3063, 1362, false);
	resname = "hangar";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2100, 1572, false);
	resname = "kosciol1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2575, 800, false);
	resname = "skala-up";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 790, 0, false);
	resname = "skala-down";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3445, 1856, false);
	resname = "skala-right";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3759, 1191, false);
	resname = "skala-down-left";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 0, 2006, false);
	resname = "politechnika1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1492, 1244, false);
	resname = "politechnika2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1723, 1152, false);
	resname = "lotnisko";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3475, 457, false);
	resname = "drogowskaz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1079, 1149, false);
	resname = "drzewka-pn-zach";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 0, 144, false);
	resname = "drzewka-pn-mid";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1184, 216, false);
	resname = "drzewka-pn";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1454, 170, false);
	resname = "drzewka-pn-wsch-1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3948, 632, false);
	resname = "drzewka-pn-wsch-2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3796, 778, false);
	resname = "drzewka-pn-wsch-3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3706, 837, false);
	resname = "drzewka-pn-wsch-4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3567, 886, false);
	resname = "drzewka-podsaskim";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1949, 452, false);
	resname = "drzewka-saski1";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1693, 195, false);
	resname = "drzewka-saski2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1883, 307, false);
	resname = "drzewka-pn-wsch-4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1576, 531, false);
	resname = "drzewka-pn-wsch-3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1447, 1725, false);
	resname = "drzewka-pn-wsch-2";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 846, 1590, false);
	resname = "drzewka-pn-wsch-3";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 520, 1609, false);
	resname = "drzewka-zus";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1074, 1025, false);
	resname = "drzewka-pd7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2577, 929, false);
	resname = "drzewka-pn-wsch-4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2952, 545, false);
	resname = "drzewka-pd7";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3086, 585, false);
	resname = "drzewka-zach6";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 3016, 585, false);
	resname = "drzewka-ing";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 947, 1113, false);
	resname = "drzewka-pn-wsch-4";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1530, 2067, false);

	resname = "przystanek";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 294, 1222, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 143, 757, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1360, 721, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 1068, 1294, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2471, 860, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2239, 759, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2732, 731, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2561, 556, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2720, 884, false);
	resname = "kosz";
	res = this.preloader.getResult(resname);
	this.map.addBuilding(resname, res, 2127, 1012, false);

	// add clouds
	resname = "chmura1";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 467, 192, 100);
	resname = "chmura2";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 392, 188, 100);
	resname = "chmura3";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 332, 136, 100);
	resname = "chmura4";
	res = this.preloader.getResult(resname);
	this.map.addCloud(resname, res, 392, 188, 100);

	// >>> ------ create interiors ------ <<<

	/**** Agencja Reklamowa 1 ****/
	resname = "intAR1";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["agencjaReklamowa1"] = interior;
	// -------
	resname = "ar1aImg";
	res = this.preloader.getResult(resname);
	var target = "intAR1r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 713,
			height: 387
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 969, 456, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "intAR1r";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(900, 40).setWorkerAlias('Pracownik'); // 1050 200
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Agencja Reklamowa 2 ****/
	resname = "intAR2";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["agencjaReklamowa2"] = interior;
	// -------
	resname = "ar2aImg";
	res = this.preloader.getResult(resname);
	target = "intAR2r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 199,
			height: 207
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1890, 445, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "intAR2r";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1070, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Agencja Reklamowa 3 ****/
	resname = "intAR3";
	interior = new Interior(resname, gameObject, "vertical", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["agencjaReklamowa3"] = interior;
	// -------
	resname = "ar3aImg";
	res = this.preloader.getResult(resname);
	target = "intAR3r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 226,
			height: 348
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 751, 684, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "intAR3r";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(900, 50).setWorkerAlias('Pracownik'); // 860
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Bank 1 ****/
	resname = "intBank1";
	interior = new Interior(resname, gameObject, "vertical", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["bank1"] = interior;
	// -------
	resname = "b1aImg";
	res = this.preloader.getResult(resname);
	target = "intBank1r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 460,
			height: 558
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 741, 320, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "intBank1r1";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1000, 40).setWorkerAlias('Pracownik'); // 900 100
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Bank 2 ****/
	resname = "intBank2";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["bank2"] = interior;
	// -------
	resname = "b2r1aImg";
	res = this.preloader.getResult(resname);
	target = "intBank2r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 136,
			height: 119
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1022, 378, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "b2r2aImg";
	res = this.preloader.getResult(resname);
	target = "intBank2r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 193,
			height: 135
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1246, 357, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "intBank2r1";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(970, 250).setWorkerAlias('Pracownik'); // 1000, 150
	interior.activateHTML();
	// -------
	resname = "intBank2r2";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(950, 200).setWorkerAlias('Pracownik'); // 950 200
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Bank 3 ****/
	resname = "intBank3";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["bank3"] = interior;
	// -------
	resname = "b3r1aImg";
	res = this.preloader.getResult(resname);
	target = "intBank3r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 216,
			height: 194
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 669, 322, true, target, false, "Porozmawiaj z<br/>pracownikiem banku", true);
	// -------
	resname = "b3r2aImg";
	res = this.preloader.getResult(resname);
	target = "intBank3r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 153,
			height: 184
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1597, 299, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "intBank3r1";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1170, 70).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------
	resname = "intBank3r2";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(910, 70).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Bank 4 ****/
	resname = "intBank4";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["bank4"] = interior;
	// -------
	resname = "b4aImg";
	res = this.preloader.getResult(resname);
	target = "intBank4_2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 160,
			height: 390
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1443, 361, true, target, false, "Podejdź do okienka", true);
	// -------
	resname = "intBank4_2";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	// -------
	resname = "b4r1aImg";
	res = this.preloader.getResult(resname);
	target = "intBank4r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 458,
			height: 572
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 362, 384, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "b4r2aImg";
	res = this.preloader.getResult(resname);
	target = "intBank4r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 398,
			height: 525
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 2219, 419, true, target, false, "Porozmawiaj&nbsp;z<br/>pracownikiem&nbsp;banku", true);
	// -------
	resname = "intBank4r1";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1100, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------
	resname = "intBank4r2";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(510, 150, "right").setWorkerAlias('Pracownik'); // 650 100
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Centrum Szkoleniowe 1 ****/
	resname = "intCS1";
	interior = new Interior(resname, gameObject, "vertical", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["centrumSzkoleniowe1"] = interior;
	// -------
	resname = "cs1aImg";
	res = this.preloader.getResult(resname);
	target = "intCS1r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 392,
			height: 320
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 798, 335, true, target, false, "Porozmawiaj z pracownikiem centrum szkoleniowego", true);
	// -------
	resname = "intCS1r";
	interior = new Interior(resname, gameObject, "uniform", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(800, 50).setWorkerAlias('Pracownik');
	// -------
	resname = "intCS1e";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS1b";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS1s";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Centrum Szkoleniowe 2 ****/
	resname = "intCS2";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["centrumSzkoleniowe2"] = interior;
	interior.enableDialogue(2000, 100, "right").setWorkerAlias('Pracownik'); // 2020 150
	// -------
	resname = "intCS2e";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS2b";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS2s";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Centrum Szkoleniowe 3 ****/
	resname = "intCS3";
	interior = new Interior(resname, gameObject, "vertical", "left");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["centrumSzkoleniowe3"] = interior;
	// -------
	resname = "cs3aImg";
	res = this.preloader.getResult(resname);
	target = "intCS3r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 219,
			height: 326
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 537, 344, true, target, false, "Porozmawiaj z pracownikiem centrum szkoleniowego", true);
	// -------
	resname = "intCS3r"; //recepcja
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(870, 200).setWorkerAlias('Pracownik');
	// -------
	resname = "intCS3e"; //sala egzaminacyjna (lista szkolen, ich hitoria itp)
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS3b"; //komputer egzaminacyjny
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS3s"; //tablica szkoleniowa (komputer egzaminacyjny)
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Centrum Szkoleniowe 4 ****/
	resname = "intCS4";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["centrumSzkoleniowe4"] = interior;
	// -------
	resname = "cs4aImg";
	res = this.preloader.getResult(resname);
	target = "intCS4r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 152,
			height: 210
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1504, 269, true, target, false, "Porozmawiaj z pracownikiem centrum szkoleniowego", true);
	// -------
	resname = "intCS4r";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(380, 100, "right").setWorkerAlias('Pracownik');
	// -------
	resname = "intCS4e";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS4b";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// -------
	resname = "intCS4s";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Urzad Skarbowy 1 ****/
	resname = "intUS";
	interior = new Interior(resname, gameObject, "vertical");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["urzadSkarbowy1"] = interior;
	// -------
	resname = "usr1aImg";
	res = this.preloader.getResult(resname);
	target = "intUS1r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 172,
			height: 155
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 196, 484, true, target, false, "Podejdź do informacji aby zadać pytanie.", true);
	// -------
	resname = "usr2aImg";
	res = this.preloader.getResult(resname);
	target = "intUS1r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 246,
			height: 225
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 886, 357, true, target, false, "Podejdź tutaj aby złożyć deklaracje.", true);
	// -------
	resname = "intUSr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUS1r1"] = interior;
	interior.enableDialogue(190, 80, "right").setWorkerAlias('Urzędnik');
	// -------
	resname = "intUSr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1000, 50).setWorkerAlias('Urzędnik'); // 1150 50
	interior.activateHTML();
	this.interiors["intUS1r2"] = interior;
	// ---------------------------------------------------

	/**** Urzad Skarbowy 2 ****/
	resname = "intUS";
	interior = new Interior(resname, gameObject, "vertical");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["urzadSkarbowy2"] = interior;
	// -------
	resname = "usr1aImg";
	res = this.preloader.getResult(resname);
	target = "intUS2r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 172,
			height: 155
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 196, 484, true, target, false, "Podejdź do informacji aby zadać pytanie.", true);
	// -------
	resname = "usr2aImg";
	res = this.preloader.getResult(resname);
	target = "intUS2r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 246,
			height: 225
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 886, 357, true, target, false, "Podejdź tutaj aby złożyć deklaracje.", true);
	// -------
	resname = "intUSr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUS2r1"] = interior;
	interior.enableDialogue(190, 80, "right").setWorkerAlias('Urzędnik');
	// -------
	resname = "intUSr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1000, 50).setWorkerAlias('Urzędnik'); // 1150 50
	interior.activateHTML();
	this.interiors["intUS2r2"] = interior;
	// ---------------------------------------------------

	/**** Urzad Skarbowy 3 ****/
	resname = "intUS";
	interior = new Interior(resname, gameObject, "vertical");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["urzadSkarbowy3"] = interior;
	// -------
	resname = "usr1aImg";
	res = this.preloader.getResult(resname);
	target = "intUS3r1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 172,
			height: 155
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 196, 484, true, target, false, "Podejdź do informacji aby zadać pytanie.", true);
	// -------
	resname = "usr2aImg";
	res = this.preloader.getResult(resname);
	target = "intUS3r2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 246,
			height: 225
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 886, 357, true, target, false, "Podejdź tutaj aby złożyć deklaracje.", true);
	// -------
	resname = "intUSr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUS3r1"] = interior;
	interior.enableDialogue(190, 80, "right").setWorkerAlias('Urzędnik');
	// -------
	resname = "intUSr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1000, 50).setWorkerAlias('Urzędnik'); // 1150 50
	interior.activateHTML();
	this.interiors["intUS3r2"] = interior;
	// -------
	resname = "intUSs_nip";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUSs_vat7";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUSs_vat7k";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUSs_pit36";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUSs_vatr";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intUSs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Urzad Pracy ****/
	resname = "intUP";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["urzadPracy"] = interior;
	// -------
	resname = "uptaImg";
	res = this.preloader.getResult(resname);
	target = "intUPt";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 142,
			height: 243
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 2049, 697, true, target, false, "Podejdź do terminalu aby pobrać numerek.", true);
	// -------
	resname = "intUPr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1190, 100).setWorkerAlias('Urzędnik');
	interior.activateHTML();
	this.interiors[resname] = interior;
	// ------- strzalka
	/*
	resname = "strzalkaImg";
	res = this.preloader.getResult(resname);
	target = "urzadPracy";
        var sprite = new createjs.SpriteSheet({
                images: [res],
                frames: {width:142, height:142},
                animations: { blank:[0] }
        });
	interior.addActiveElement(sprite,resname,30,850,true,target);
	*/
	// -------
	resname = "intUPr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1320, 100).setWorkerAlias('Urzędnik');
	interior.activateHTML();
	this.interiors[resname] = interior;
	// ------- strzalka
	/*
	resname = "strzalkaImg";
	res = this.preloader.getResult(resname);
	target = "urzadPracy";
        var sprite = new createjs.SpriteSheet({
                images: [res],
                frames: {width:142, height:142},
                animations: { blank:[0] }
        });
	interior.addActiveElement(sprite,resname,30,850,true,target);
	*/
	// -------
	resname = "intUPs";
	interior = new Interior(resname + "1", gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUPs1"] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUPs";
	interior = new Interior(resname + "2", gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["intUPs2"] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intUPt";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	// ------- strzalka
	/*
	resname = "strzalkaImg";
	res = this.preloader.getResult(resname);
	target = "urzadPracy";
        var sprite = new createjs.SpriteSheet({
                images: [res],
                frames: {width:142, height:142},
                animations: { blank:[0] }
        });
	interior.addActiveElement(sprite,resname,30,850,true,target);
	*/
	// ------- karteczki
	resname = "upn1aImg";
	res = this.preloader.getResult(resname);
	target = "intUPr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 293,
			height: 287
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1360, 1090, true, target);
	// -------
	resname = "upn2aImg";
	res = this.preloader.getResult(resname);
	target = "intUPr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 293,
			height: 287
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1360, 1090, true, target);
	// ------- przyciski terminalu
	resname = "uptp1aImg";
	res = this.preloader.getResult(resname);
	target = "intUPr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 573,
			height: 115
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 661, 189, true, target, true);
	// -------
	resname = "uptp2aImg";
	res = this.preloader.getResult(resname);
	target = "intUPr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 573,
			height: 115
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 661, 394, true, target, true);
	// ---------------------------------------------------

	/**** Agencja Posrednictwa Pracy ****/
	resname = "intAPP";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["agencjaPosrednictwaPracy"] = interior;
	// -------
	resname = "appr1aImg";
	res = this.preloader.getResult(resname);
	target = "intAPPr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 379,
			height: 335
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 955, 512, true, target, false, "Porozmawiaj z urzędnikiem", true);
	// -------
	resname = "appr2aImg";
	res = this.preloader.getResult(resname);
	target = "intAPPr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 329,
			height: 386
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1628, 518, true, target, false, "Porozmawiaj z urzędnikiem", true);
	// -------
	resname = "intAPPr1";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1000, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------
	resname = "intAPPr2";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1000, 50).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// ---------------------------------------------------

	/**** ZUS ****/
	resname = "intZ";
	interior = new Interior(resname, gameObject, "vertical", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["zus"] = interior;
	// -------
	resname = "zustaImg";
	res = this.preloader.getResult(resname);
	target = "intZt";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 280,
			height: 517
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 2606, 535, true, target, false, "Podejdź do terminalu", true);
	// -------
	resname = "intZt";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	// ------- przyciski terminalu zus
	resname = "zustp1aImg";
	res = this.preloader.getResult(resname);
	target = "intZr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 589,
			height: 89
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 520, 396, true, target, true);
	// -------
	resname = "zustp2aImg";
	res = this.preloader.getResult(resname);
	target = "intZr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 590,
			height: 90
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 519, 547, true, target, true);
	// ------- karteczki
	resname = "zusn1aImg";
	res = this.preloader.getResult(resname);
	target = "intZr1";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 293,
			height: 287
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1360, 1090, true, target);
	// -------
	resname = "zusn2aImg";
	res = this.preloader.getResult(resname);
	target = "intZr2";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 293,
			height: 287
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 1360, 1090, true, target);
	// ------- rozmowy
	resname = "intZr1";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1150, 100).setWorkerAlias('Pracownik');
	// -------
	resname = "intZr2";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	interior.enableDialogue(1200, 150).setWorkerAlias('Pracownik');
	interior.activateHTML();
	this.interiors[resname] = interior;
	// -------
	/*
	resname = "intZs";
	interior = new Interior(resname,gameObject,"uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	*/
	// -------
	resname = "intZs_zua";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intZs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intZs_rca";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intZs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// -------
	resname = "intZs_dra";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult("intZs");
	interior.init(res);
	this.interiors[resname] = interior; //resname
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Biurko ****/
	resname = "biurko";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["zlecenia"] = interior;
	interior.activateHTML();

	resname = "biurko";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["noweZlecenia"] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	/**** Biuro gracza ****/
	resname = "biuroGracza";
	interior = new Interior(resname, gameObject, "uniform", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["biuroGracza"] = interior;
	// -------
	resname = "biuroTlo";
	res = this.preloader.getResult(resname);
	target = "back";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 1920,
			height: 1080
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 0, 0, false, target);
	// -------
	resname = "treeSprite";
	res = this.preloader.getResult(resname);
	target = "back";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 980,
			height: 720
		},
		animations: {
			blank: [0, 20, true, 1]
		}
	});
	interior.addActiveElement(sprite, resname, 544, 0, false, target);
	// -------
	resname = "komputerSprite";
	res = this.preloader.getResult(resname);
	target = "internet";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 193,
			height: 155
		},
		animations: {
			blank: [0],
			opening: [0, 23, false, 1]
		}
	});
	interior.addActiveElement(sprite, resname, 880, 507, true, target, true, "Włącz laptopa", true);
	// -------

	/**** Komputer ****/
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["internet"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["internetBankowosc"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["internetCEIDG"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["internetKsiegowosc"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["finanse"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["statystyki"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["dokumenty"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["pracownicy"] = interior;
	interior.activateHTML();
	// -------
	resname = "komputerScreen";
	interior = new Interior(resname, gameObject, "horizontal");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors["skrzynka"] = interior;
	interior.activateHTML();
	// ---------------------------------------------------

	//pass current building id to interior request
	function biuroZleceniaDataCallback() {
		var budDat = Building.current.getBuildingData();
		return {
			buildingId: budDat['id']
		};
	}

	/**** Kontrahent ****/
	resname = "biuroZlecenia1";
	interior = new Interior(resname, gameObject, "vertical", "center");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	interior.getDataCallback = biuroZleceniaDataCallback;
	// ---
	resname = "bz1raImg";
	res = this.preloader.getResult(resname);
	target = "biuroZlecenia1r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 299,
			height: 193
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 874, 377, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "biuroZlecenia1r";
	interior = new Interior(resname, gameObject, "uniform", "right");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1300, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------
	resname = "biuroZlecenia2";
	interior = new Interior(resname, gameObject, "vertical");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.activateHTML();
	interior.getDataCallback = biuroZleceniaDataCallback;
	// ---
	resname = "bz2raImg";
	res = this.preloader.getResult(resname);
	target = "biuroZlecenia2r";
	var sprite = new createjs.SpriteSheet({
		images: [res],
		frames: {
			width: 299,
			height: 196
		},
		animations: {
			blank: [0]
		}
	});
	interior.addActiveElement(sprite, resname, 874, 374, true, target, false, "Porozmawiaj z pracownikiem", true);
	// -------
	resname = "biuroZlecenia2r";
	interior = new Interior(resname, gameObject, "uniform");
	res = this.preloader.getResult(resname);
	interior.init(res);
	this.interiors[resname] = interior;
	interior.enableDialogue(1400, 100).setWorkerAlias('Pracownik');
	interior.activateHTML();
	// -------

	// set container
	var newcontainer = this.map.getContainer();
	this.container = newcontainer;
	stage.addChild(this.container);

	// also check current hash at game init
	this.parseUrl();

	// hide preloader
	$("#loader").fadeOut(1000);

	var hash = window.location.hash;

	if (window.parsed == false)
		windowParseUrl();

	if (hash != "#register" && hash != "#password")
		window.location.hash = "";

	// setup crossroads on the map
	for (var a = 0; a < this.map.traffic.roads.length; a++) {
		var firstCrossroad = this.map.traffic.crossroads[this.map.traffic.roads[a].s1];
		var secondCrossroad = this.map.traffic.crossroads[this.map.traffic.roads[a].s2];
		if (firstCrossroad == undefined || secondCrossroad == undefined)
			continue;
	}

	this.stage.update();
};

Game.prototype.drawLine = function(a, b) {
	var g = new createjs.Graphics();
	g.setStrokeStyle(1);
	g.beginStroke(createjs.Graphics.getRGB(255, 0, 0));
	g.beginFill(createjs.Graphics.getRGB(255, 0, 0));
	g.drawCircle(0, 0, 3);
	var g = new createjs.Graphics();
	g.setStrokeStyle(1);
	g.beginStroke(createjs.Graphics.getRGB(255, 0, 0));
	g.beginFill(createjs.Graphics.getRGB(255, 0, 0));
	//g.drawCircle(0,0,3);
	var s = new createjs.Shape(g);
	//s/.x = firstCrossroad.position.x;
	//s.y = firstCrossroad.position.y;
	s.graphics.moveTo(a.x, a.y);
	s.graphics.lineTo(b.x, b.y);
	this.map.container.addChild(s);
}

Game.prototype.keyboard = function(event) {
	// scrolling containers using arrow keys
	if (this.map != null) {
		var c = this.container;
		var i, w, h;
		if (this.currentInterior == -1) {
			i = this.map.getImage();
			w = i.width - this.canvas.width;
			h = i.height - this.canvas.height;
		} else {
			i = this.interiors[this.currentInterior].image;
			s = this.getScaleInterior();
			w = (i.width * s) - this.canvas.width;
			h = (i.height * s) - this.canvas.height;
		}

		switch (event.which) {
			case 37:
				if (this._enableMapMovement) { // left
					if (c.x < 0) c.x += 10;
					else c.x = 0;
				} else return;
				break;
			case 38:
				if (this._enableMapMovement) { // up
					if (this.currentInterior == -1 && c.y < 0) c.y += 10;
				} else return;
				break;
			case 39:
				if (this._enableMapMovement) { // right
					if (c.x > -w) c.x -= 10;
					else c.x = -w;
				} else return;
				break;
			case 40:
				if (this._enableMapMovement) { // down
					if (this.currentInterior == -1 && c.y > -h) c.y -= 10;
				} else return;
				break;
			default:
				return; // exit this handler for other keys
		}
		if (this.currentInterior == -1) this.updateMinimap();
	}
	event.preventDefault();
};

Game.prototype.setContainer = function(c, interior) {
	this.currentInterior = typeof interior !== 'undefined' ? interior : -1;

	if (this.currentInterior != -1) {
		if ($("#button-back").not(":visible")) {
			$("#button-back").clearQueue().finish().fadeIn(500).addClass("hover1").delay(200).queue(function() {
				$(this).removeClass("hover1");
				$("#button-back").tipsy({
					gravity: 'w',
					trigger: 'manual',
					html: true
				}).tipsy('show');

				if ($("#rightbuttons").is(":visible")) {
					$("#rightbuttons").fadeOut(500);
					if ($("#symbol-biuro").hasClass("hover2")) {
						$("#symbol-biuro").trigger("click");
					}
				}

				if ($("#minimap").is(":visible")) {
					$("#minimap").fadeOut(500, function() {
						checkSize();
						$("#minimap-radar").css("display", "none");
						$("#minimap-linkback").css("display", "block");

						$("#symbol-hidemap").clearQueue().finish().animate({
							"right": "10px"
						}, 1000, "easeInExpo");
						$("#bottombar").clearQueue().finish().animate({
							right: "-240px"
						}, 1000, "easeInExpo");
						$("#rightbuttons").clearQueue().finish().animate({
							marginRight: "80px"
						}, 1000, "easeInExpo");
						$("#symbol-hidemap-img").removeClass("hidemap");
						$("#symbol-hidemap-img").addClass("showmap");
					});
				}
			});
		}
	} else {
		$("#minimap-radar").css("display", "block");
		$("#minimap-linkback").css("display", "none");
		$("#button-back").fadeOut(1000).tipsy({
			gravity: 'w',
			trigger: 'manual',
			html: true
		}).tipsy('hide');
		$("#rightbuttons").fadeIn(500).tipsy({
			gravity: 'w',
			trigger: 'manual',
			html: true
		}).tipsy('show');
	}

	var game = this;

	// if user logged in - enter the building
	$.get(window.links.studentAjaxIsLoggedIn, function(result) {
		if (result == "1" && window.isLoggedIn) {
			// reset container settings
			game.container.alpha = 1;
			game.container.scaleX = 1;
			game.container.scaleY = 1;

			// switch containers
			game.container = c;
			game.stage.removeAllChildren();
			game.stage.addChild(c);
		}

	});
};

Game.prototype.hideAllTooltips = function() {
	$(".gameTooltip").each(function() {
		var tname = $(this).attr('aria-describedby');
		var child = $("#" + tname);
		if (child.length > 0) {
			$(this).tooltip('close');
			$(this).attr("title", "");
		}
		$(this).attr("canvasX", "-500");
		$(this).attr("canvasY", "-500");
		$(this).prop("canvasX", "-500");
		$(this).prop("canvasY", "-500");
		$(this).css({
			top: "-500px",
			left: "-500px"
		});
	});
}

Game.prototype.parseUrl = function() {
	var hash = window.location.hash;

	$('.interiorHTMLElement').remove(); //hide additional interior elements
	$("#dialogue").hide();

	// hide all tooltips from previous game state (if any)
	this.hideAllTooltips();

	// changing game state, activating actions and animations
	switch (hash) {
		case "#tutorial":

		case "#city": // back to city from building
			if (this.currentInterior != -1) {
				createjs.Tween.get(this.interiors[this.currentInterior].getContainer()).to({
					alpha: 0
				}, 1000);
			}
			//disable dialogue event handlers on exit
			$(document).off('.przedsiebiorcaDialogueEvents');
		default:
			var intname = hash.replace("#", "");

			// TODO check if part of the string is kontrahent- show interior accordingly

			this.resize();

			var interior = this.interiors[intname];
			if (interior != null) {
				if (this.currentInterior != -1) {
					//	this.interiors[this.currentInterior].getContainer().alpha=1;
					//	this.interiors[this.currentInterior].getContainer().scaleX = 1;
					//      this.interiors[this.currentInterior].getContainer().scaleY = 1;
					this.interiors[this.currentInterior].getContainer().x = 0;
					this.interiors[this.currentInterior].getContainer().y = 0;
				}
				this.setContainer(interior.getContainer(), intname);
				this.interiors[this.currentInterior].getContainer().alpha = 0;
				this.interiors[this.currentInterior].getContainer().scaleX = 1;
				this.interiors[this.currentInterior].getContainer().scaleY = 1;
				this.scaleInterior();

				interior.scrollToPos();
				//interior.openTooltips();

				var tween = createjs.Tween.get(this.interiors[this.currentInterior].getContainer())
					.to({
						alpha: 1
					}, 1000).call(function() {
						interior.openTooltips();
					});
				game.scrollable = true;

				//if(hash=="#urzadPracy_formularz")
				//	activateForm(1);
				//else if(hash=="#internet")
				//	activateForm(2);

				interior.enableAdditionalElements(); //enables additional html elements
			} else if (this.map != null) {
				this.setContainer(this.map.getContainer());
				this.map.container.x = -this.map.image.width / 3;
				this.map.container.y = -this.map.image.height / 3;
				game.scrollable = false;
			}
			break;
	}
}

Game.prototype.scaleInterior = function() {
	if (this.currentInterior != -1) //>=0)
	{
		if (this.interiors[this.currentInterior].isHorizontalStretch()) //hstretch)
			this.interiors[this.currentInterior].container.scaleX = this.interiors[this.currentInterior].container.scaleY = this.getScaleInterior();
		else
			this.interiors[this.currentInterior].container.scaleY = this.interiors[this.currentInterior].container.scaleX = this.getScaleInterior();
	}
}

Game.prototype.getScaleInterior = function() {
	if (this.currentInterior != -1) //>=0)
	{
		if (this.interiors[this.currentInterior].isHorizontalStretch()) //hstretch)
		{
			var initialWidth = this.interiors[this.currentInterior].image.width;
			var targetWidth = this.canvas.width;
			return scale = targetWidth / initialWidth;
		} else {
			var initialHeight = this.interiors[this.currentInterior].image.height;
			var targetHeight = this.canvas.height;
			return scale = targetHeight / initialHeight;
		}
	} else return 1;
}

Game.prototype.updateMinimap = function() {
	var mw = $("#minimap").width();
	var mh = $("#minimap").height();
	var rw = $("#minimap-radar").width();
	var rh = $("#minimap-radar").height();

	ox = ((-this.container.x) / (this.map.image.width - this.canvas.width)) * (mw - rw - 5);
	oy = ((-this.container.y) / (this.map.image.height - this.canvas.height)) * (mh - rh - 5);

	var tx = this.container.x;
	var ty = this.container.y;
	var mx = this.map.image.width;
	var my = this.map.image.height;
	var cw = this.canvas.width;

	$("#minimap-radar").css({
		left: ox + "px",
		top: oy + "px"
	});
}

Game.prototype.isLoading = function() {
	return (this.preloader.progress > 0 && this.preloader.progress < 1) ? true : false;
}
